/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import com.james.tinkerscalibration.Utils;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ArmorImpregnableModifier
extends Modifier
implements ToolDamageModifierHook {
    private static final TinkerDataCapability.TinkerDataKey<Integer> IMPREGNABLE = TConstruct.createKey((String)"impregnable");

    public ArmorImpregnableModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, ArmorImpregnableModifier::onHurt);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.TOOL_DAMAGE);
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(IMPREGNABLE, false, null));
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int level = (Integer)holder.get(IMPREGNABLE, (Object)0);
            if (level > 0 && attacker != null && event.getAmount() != 0.0f) {
                int effectLevel = Math.min(7, ((TinkerEffect)Utils.impregnableEffect.get()).getLevel(living) + 1);
                ((TinkerEffect)Utils.impregnableEffect.get()).apply(living, 100, effectLevel, true);
            }
        });
    }

    private static float getBonus(LivingEntity living, RegistryObject<? extends TinkerEffect> effect, ModifierEntry modifier, float scale) {
        int effectLevel = ((TinkerEffect)effect.get()).getLevel(living) + 1;
        return (float)(modifier.getLevel() * effectLevel) / scale;
    }

    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        float bonus = ArmorImpregnableModifier.getBonus(holder, Utils.impregnableEffect, modifier, 6.0f);
        int off = 0;
        for (int i = 0; i < amount; ++i) {
            if (!(RANDOM.nextFloat() >= 1.0f / bonus)) continue;
            ++off;
        }
        return amount - off;
    }
}

